import MCS6_2 as F
import numpy as np
import matplotlib.pyplot as plt
plt.close('all')
plt.rcParams.update({'font.size': 8})
plt.rcParams.update({'pdf.fonttype': 42})

###
name = '61Zn'
scan = np.linspace(80,300,45).round(3)
scan2 = None
what = (None, None)
tr = (0,200)

A = F.MCS6_DATA(['Zn-run_241'], resolution=0.1)
A.data = A.data[:380]
A.add_all_slices()

cm = 1 / 2.54
figsize = (9.3*cm, 3.5*cm)
fig, ax = plt.subplots(figsize=figsize)

xlabel = f'(ToF - {A.caloff} µs) / µs'
xlabel = '(ToF - 18800 µs) / µs'
start = 0
stop = -1

binusm = 10

xs = A.bin_data(A.data, binusm)
ts = A.index_time(np.arange(xs.shape[-1]), binsum=binusm) + A.caloff

plt.fill_between(ts-18800, xs, lw=0.5, ec='k', fc='0.75')
plt.xlim(5.3, 12.7)
plt.ylim(0.5, xs.max()*1.4)
plt.yscale('log')

plt.text(18806-18800, 3, '$^{61}$Cu$^{+}$')
plt.text(18806.92-18800, 20, '$^{61}$Zn$^{+}$')
plt.text(18810.35-18800, 550, '$^{42}$Ca$^{19}$F$^{+}$')

plt.xlabel(xlabel)
plt.ylabel('counts / 8 ns bin')

plt.minorticks_on()
ax.tick_params(which='minor', length=2)
ax.tick_params(which='major', length=4)

plt.savefig('file241_1000revs.pdf', bbox_inches='tight', pad_inches=0.01)