from matplotlib import pyplot as plt
import numpy as np

plt.rcParams.update({'font.size': 8})
plt.rcParams.update({'pdf.fonttype': 42})
plt.close('all')

name = ['$t_{1/2}$', 'BR', '$Q_\mathrm{AME2020}$', '$Q_\mathrm{new}$']
# name = ['$t_{1/2}$', 'BR', '$Q_\mathrm{AME2020}$', '']
contribution = np.array([0.0069, 0.0049, 0.0102, 0])
c1 = 0.00258
c2 = 0.0025
c3 = 0.0003
hatch = ['', '//', '\\\\\\', '\\\\\\']

cm = 1 / 2.54
figsize = (9.3*cm, 5*cm)
fig, ax = plt.subplots(figsize=figsize)

from  matplotlib import colors
lightfirebrick = np.array(colors.to_rgb('firebrick'))*0.75+np.full(3, 1-0.75)
strongsteelblue = np.array(colors.to_rgb('steelblue'))*1.2-np.full(3, 1-0.8)

kwargs = {'hatch':hatch, 'ec':'0', 'lw':0.7}
arrow_Ga = {'width':0.8,'headwidth':4,'headlength':4, 'facecolor':lightfirebrick}
arrow_Zn = {'width':0.8,'headwidth':4,'headlength':4, 'facecolor':'steelblue'}

plt.bar(name, 10**3.6777*np.log(10)*contribution, color='0.75', **kwargs)
plt.bar(3, 10**3.6812*np.log(10)*c1, color='gold', **kwargs)
plt.bar(2.95, 10**3.6812*np.log(10)*c2, color=lightfirebrick, **kwargs, width=0.6)
plt.text(3.5,22, 'ME$_\mathrm{Ga}$', color='firebrick')
plt.bar(3.05, 10**3.6812*np.log(10)*c3, color='steelblue', **kwargs, width=0.6)
plt.text(3.5,4, 'ME$_\mathrm{Zn}$', color=strongsteelblue)

plt.xlabel('experimental uncertainty contributions')
plt.ylabel('$\Delta \\mathcal{F}t$ / s')

plt.text(-0.4,85,'$t_{1/2}$: $^{61}$Ga half-life\nBR: branching ratio\n$Q=$ME$_\mathrm{Zn}-$ME$_\mathrm{Ga}$')

plt.xlim(right=4.1)

plt.savefig('ft_uncertainty_contribution.pdf', bbox_inches='tight', pad_inches=0.01)