########## box plots FA all 24 replicates!!! ####
###24.08.23

rm(list=ls(all=TRUE)); # graphics.off()

setwd("Z:/AllgSystZoo/aa-Sharing/GrakoRESPONSE/Carolina/Lipid_analyses/Klockmann_WarmerWinters")

par(mfrow=c(2,4))


###define assumption function for ANOVA: #####
chk.assumpt <- function(){
  ####### C H E C K   f o r   A S S U M P T I O N S ! #######
  ##### (1) Homogeneity of variances? (true if p>0.05) ###### 
  print(fligner.test(depend ~ TREAT, data=data.0))   # check for homogeneity, if significant, variances are not homogeneous
  ##### (2) Residuals normal distributed? (true if p>0.05) ####
  print(shapiro.test(residuals(lmod1)))  #NOTE: this checks the residuals for just the last lm-call you've been running! 
}


input.file <-"FAresults_all.txt" 
#input.file <-"FAresults_all.rtxt" 


########################## read in data into R ########################## 
data.0 <- read.table(input.file, sep="\t", dec=".", header=TRUE, na.strings = ""); print(input.file)

levels(data.0$TREAT)
data.0$TREAT <- factor(data.0$TREAT, levels=c('C', 'M', 'W'))
levels(data.0$TREAT)

data.0 <- as.data.frame(data.0) 


#names(data.0) 
# [1] "Amount.Per.1.spiderling" "Name.FA"                 "TREAT"                   "C16.0"                  
# [5] "C18.0"                   "C20.0"                   "C21.0"                   "C22.0"                  
# [9] "C16.1n.9"                "C16.1n.7"                "C18.1n.7"                "C18.1n.12"              
# [13] "C18.1n.9"                "C20.1n.9"                "C20.1n.11"               "C22.1n.9"               
# [17] "C16.3n.3"                "C16.4n.3"                "C18.4n.3"                "C18.3n.3"               
# [21] "C20.3n.3"                "C20.5n.3"                "C20.4n.3"                "C22.5n.3"               
# [25] "C22.6n.3"                "C18.2n.6"                "C18.3.5...."             "C18.3n.6"               
# [29] "C18.4.5...."             "C20.2n.6"                "C20.3n.6"                "C20.4n.6"               
# [33] "C22.2n.6"                "C22.5n.6"                "E.E18.2n.6"              "SFA"                    
# [37] "MUFA"                    "n.3_PUFA"                "n.6_PUFA"                "TOTAL"                  
# [41] "FA.."                    "SFA.percent"             "MUFA.perent"             "Omega.3.percent"        
# [45] "Omega.6.percent"


## too lazy to configure the boxplot: --> use a function:
FA.boxplot.per.ind <- function() {
  boxplot(depend ~ TREAT, data=data.0,col=c("#0000FF","#009999","#99cccc"), ylim=c(0,1.15*max(depend)))
  title(main=paste("ug ",FA.plot.title, "per ind., p= ", round(anova(lmod1)[[1,5]],2),sep=" "), cex.main=1.0, line=-0.80)
}
FA.boxplot.percent <- function() {
  boxplot(depend ~ TREAT, data=data.0, ylim=c(0,1.15*max(depend)))
  title(main=paste(FA.plot.title, "% of total FA, p= ", round(anova(lmod1)[[1,5]],2),sep=" "), cex.main=1.0, line=-0.80)
}



par(mfrow=c(2,4))


for (i.FA in c(5,13,20,26) ) {  # i.FA<-5   ## choose the col.numbers of the data set with the interesting FA 
  
  ####### STAT Model for percentages ###### 
  depend <- 100 * data.0[,i.FA]   / data.0$TOTAL 
  FA.plot.title <-      names(data.0)[i.FA]
  lmod1 <- lm(depend ~ TREAT ,data=data.0)
  print(anova(lmod1))
  print(chk.assumpt())
  FA.boxplot.percent()
}


for (i.FA in c(5,13,20,26) ) {  # i.FA<-5
  ####### STAT Model for per individual ###### 
  depend <-  data.0[,i.FA]   / 1  
  FA.plot.title <-      names(data.0)[i.FA]
  lmod1 <- lm(depend ~ TREAT ,data=data.0)
  print(anova(lmod1))
  print(chk.assumpt())
  FA.boxplot.per.ind()
}


par(mfrow=c(2,4))


for (i.FA in c(22:28) ) {  # i.FA<-5   ## choose the col.numbers of the data set with the interesting FA 
  
  ####### STAT Model for percentages ###### 
  depend <- 100 * data.0[,i.FA]   / data.0$TOTAL 
  FA.plot.title <-      names(data.0)[i.FA]
  lmod1 <- lm(depend ~ TREAT ,data=data.0)
  print(anova(lmod1))
  print(chk.assumpt())
  FA.boxplot.percent()
}


par(mfrow=c(2,2))

for (i.FA in c(22:28) ) {  # i.FA<-5
  ####### STAT Model for per individual ###### 
  depend <-  data.0[,i.FA]   / 1  
  FA.plot.title <-      names(data.0)[i.FA]
  lmod1 <- lm(depend ~ TREAT ,data=data.0)
  print(anova(lmod1))
  print(chk.assumpt())
  FA.boxplot.per.ind()
}

### each one so I can edit the boxplots 

par(mfrow=c(1,1))
par(bg = "#bdd7ee")
####### STAT Model ###### 
depend <- data.0$SFA  / 1
lmod1 <- lm(depend ~ TREAT ,data=data.0)
print(anova(lmod1))
print(chk.assumpt())
boxplot(depend ~ TREAT, data=data.0,col=c("#0000FF","#009999","#99cccc"),xlab = "Treatment",ylab="SFA [ug per ind.]",cex.lab = 1.5, cex.axis = 1.5);title(main=paste("Saturated FA ","p=",round(anova(lmod1)[[1,5]],2),sep=" "), cex.main=2)

####### STAT Model ###### 
depend <- data.0$MUFA  / 1
lmod1 <- lm(depend ~ TREAT ,data=data.0)
print(anova(lmod1))
print(chk.assumpt())
boxplot(depend ~ TREAT, data=data.0,col=c("#0000FF","#009999","#99cccc"),xlab = "Treatment",ylab="MUFA [ug per ind.]",cex.lab = 1.5, cex.axis = 1.5);title(main=paste("Monounsaturated FA ","p=",round(anova(lmod1)[[1,5]],2),sep=" "), cex.main=2)

####### STAT Model ###### 
depend <- data.0$n.3_PUFA  / 1
lmod1 <- lm(depend ~ TREAT ,data=data.0)
print(anova(lmod1))
print(chk.assumpt())
boxplot(depend ~ TREAT, data=data.0,col=c("#0000FF","#009999","#99cccc"),xlab = "Treatment",ylab="n-3 PUFA [ug per ind.]",cex.lab = 1.5, cex.axis = 1.5);title(main=paste("Omega-3 Polyunsaturated FA ","p=",round(anova(lmod1)[[1,5]],3),sep=" "), cex.main=1.5)


####### STAT Model ###### 
depend <- data.0$n.6_PUFA  / 1
lmod1 <- lm(depend ~ TREAT ,data=data.0)
print(anova(lmod1))
print(chk.assumpt())
boxplot(depend ~ TREAT, data=data.0,col=c("#0000FF","#009999","#99cccc"),xlab = "Treatment",ylab="n-6 PUFA [ug per ind.]",cex.lab = 1.5, cex.axis = 1.5);title(main=paste("Omega-6 Polyunsaturated FA ","p=",round(anova(lmod1)[[1,5]],2),sep=" "), cex.main=1.5)


######### essential PUFA fatty acids 
par(mfrow=c(2,2))

####### STAT Model ###### 
depend <- data.0$C18.2n.6  / 1
lmod1 <- lm(depend ~ TREAT ,data=data.0)
print(anova(lmod1))
print(chk.assumpt())
boxplot(depend ~ TREAT, data=data.0,col=c("#0000FF","#009999","#99cccc"),xlab = "Treatment",ylab="C18.2n.6 [ug per ind.]",cex.lab = 1.5, cex.axis = 1.5);title(main=paste("Linoleic acid ","p=",round(anova(lmod1)[[1,5]],2),sep=" "), cex.main=1.5)

####### STAT Model ###### 
depend <- data.0$C18.3n.3  / 1
lmod1 <- lm(depend ~ TREAT ,data=data.0)
print(anova(lmod1))
print(chk.assumpt())
boxplot(depend ~ TREAT, data=data.0,col=c("#0000FF","#009999","#99cccc"),xlab = "Treatment",ylab="C18.3n.3 [ug per ind.]",cex.lab = 1.5, cex.axis = 1.5);title(main=paste("alfa-linolenic acid ","p=",round(anova(lmod1)[[1,5]],2),sep=" "), cex.main=1.5)

####### STAT Model ###### 
depend <- data.0$C20.4n.6  / 1
lmod1 <- lm(depend ~ TREAT ,data=data.0)
print(anova(lmod1))
print(chk.assumpt())
boxplot(depend ~ TREAT, data=data.0,col=c("#0000FF","#009999","#99cccc"),xlab = "Treatment",ylab="C20.4n.6 [ug per ind.]",cex.lab = 1.5, cex.axis = 1.5);title(main=paste("arachidonic acid ","p=",round(anova(lmod1)[[1,5]],2),sep=" "), cex.main=1.5)

####### STAT Model ###### 
depend <- data.0$C20.5n.3  / 1
lmod1 <- lm(depend ~ TREAT ,data=data.0)
print(anova(lmod1))
print(chk.assumpt())
boxplot(depend ~ TREAT, data=data.0,col=c("#0000FF","#009999","#99cccc"),xlab = "Treatment",ylab="C20.5n.3  [ug per ind.]",cex.lab = 1.5, cex.axis = 1.5);title(main=paste("eicosapentaenoic acid ","p=",round(anova(lmod1)[[1,5]],2),sep=" "), cex.main=1.5)

