########## box plots FA French warmer winter project grouped by month####
### 13.10.23

rm(list=ls(all=TRUE)); # graphics.off()

setwd("~/Bacherlorthesis/Lipids") 

#libraries 
library(ggplot2)
library(dplyr)
library(ggsignif)
library(ggpubr)

#get data
famonth <- read.csv("FA_Lillyresults1.csv", header =T, stringsAsFactors = T)
famonth

#levels
levels(famonth$Opening)
#"January"  "February" "March" 
famonth$Opening <- ordered(famonth$Opening, levels = c("January","February","March")) #use this to order

#grouped boxplot by opening by FA 

#SFA
ggplot(famonth, aes(x=Opening, y=SFA, fill=TREAT)) + 
  geom_boxplot() +
  scale_fill_manual(values=c("#FFCC99","#f58231","#FF3300"))+
  geom_signif(comparisons = list(c("January","February","March")), map_signif_level = c("***"=0.001, "**"=0.01, "*"=0.05)) +
  facet_wrap(~Opening, scale="free") +
  theme_classic()

#MUFA
ggplot(famonth, aes(x=Opening, y=MUFA, fill=TREAT)) + 
  geom_boxplot() +
  scale_fill_manual(values=c("#FFCC99","#f58231","#FF3300"))+
  facet_wrap(~Opening, scale="free") +
  theme_classic()

#n.3_PUFA
ggplot(famonth, aes(x=Opening, y=n.3_PUFA, fill=TREAT)) + 
  geom_boxplot() +
  scale_fill_manual(values=c("#FFCC99","#f58231","#FF3300"))+
  facet_wrap(~Opening, scale="free") +
  theme_classic()

#n.6_PUFA
ggplot(famonth, aes(x=Opening, y=n.6_PUFA, fill=TREAT)) + 
  geom_boxplot() +
  scale_fill_manual(values=c("#FFCC99","#f58231","#FF3300"))+
  facet_wrap(~Opening, scale="free") +
  theme_classic()


