###Survival french winter statistics 
#28.09.23 

#clean everything
rm(list = ls())

#set working directory
setwd("~/brain/Lilly")

#libraries 
library(ggplot2)
library(dplyr)
library(ggsignif)
library(ggpubr)


#get data
survival <- read.csv("Data_for_R_6.csv", header =T, stringsAsFactors = T)
survival

#levels
levels(survival$Opening)
#"January"  "February" "March" 
survival$Opening <- ordered(survival$Opening, levels = c("January","February","March")) #use this to order
levels(survival$WinterTreatment) 
#"FW"   "FW+"  "FW++"

#plots
#survival all
plot(survival$PercentageAlive~as.factor(survival$WinterTreatment),col=c("#FFCC99","#f58231","#FF3300"))


#survival only MRL 

plot(MRL$PercentageAlive~as.factor(MRL$WinterTreatment),col=c("#FFCC99","#f58231","#FF3300"))
kruskal.test(MRL$PercentageAlive,MRL$WinterTreatment)



## normality test
qqnorm(survival$PercentageAlive) 
qqline(survival$PercentageAlive)
bartlett.test(survival$PercentageAlive,survival$WinterTreatment)
#cBartlett's K-squared = 26.948, df = 2, p-value = 1.407e-06
#p-value under 0,05 means that no equal variance -> no ANOVA, we are going to do Kruskall Wallis

#significant test
kruskal.test(survival$PercentageAlive,survival$WinterTreatment)
#Kruskal-Wallis chi-squared = 27.27, df = 2, p-value = 1.198e-06
#there is a significant difference

#plots location and test
plot(survival$PercentageAlive~as.factor(survival$Region))
kruskal.test(survival$PercentageAlive,survival$Region)
#Kruskal-Wallis chi-squared = 1.7541, df = 2, p-value = 0.416
#there is no significdant difference

#plots HatchingSuccess
plot(survival$HatchingSuccess~as.factor(survival$Region))

#plot Clutchsize
plot(survival$TotalEggSac~as.factor(survival$Region))

#now we are subset (for March)
Mar = subset(survival,survival$Opening == "March")
Mar
plot(Mar$PercentageAlive~as.factor(Mar$WinterTreatment),col=c("#FFCC99","#f58231","#FF3300"))


#ggplot survival vs opening 
dodge <- position_dodge(width = 0.5)

B <- ggplot(survival, aes(x= Opening, y= PercentageAlive, fill= WinterTreatment)) +
  geom_violin(trim = FALSE, color = "#A0A0A0", lwd = 0.3, position = dodge) +
  scale_fill_manual(values=c("beige","bisque2", "darkorange")) +
  geom_boxplot(width = 0.1, color = "#000000", lwd = 0.6, position = dodge) +
  scale_fill_manual(values=c("#FFCC99","#f58231","#FF3300")) +
                facet_wrap(~Opening, scales = "free") +
              theme_bw()    
B

tiff("Survival_openingAll.tiff", units = "px", width = 7000, height = 4000, res = 600)
B
dev.off()

#geom_signif(comparisons = list(c("January","February"), c("February","March"), c("January","March")),
            #map_signif_level = c("*"=0.001, "*"=0.01, ""=0.05) 

#subset of MR + Lipids

MRL = subset(survival,survival$Usage == "MR_L")
MR = subset(survival,survival$Usage == "MR")
L = subset(survival,survival$Usage == "L")

#ggplot subset Metabolic Rate
dodge <- position_dodge(width = 0.5)

MRL2 <- ggplot(MRL, aes(x= Opening, y= PercentageAlive, fill= WinterTreatment)) +
  geom_violin(trim = FALSE, color = "#A0A0A0", lwd = 0.3, position = dodge) +
  scale_fill_manual(values=c("beige","bisque2", "darkorange")) +
  geom_boxplot(width = 0.1, color = "#000000", lwd = 0.6, position = dodge) +
  scale_fill_manual(values=c("#FFCC99","#f58231","#FF3300")) +
  geom_signif(comparisons = list(c("January","February","March")),
              map_signif_level = c("*"=0.001, "*"=0.01, ""=0.05) + 
  facet_wrap(~Opening, scales = "free") +
  theme_bw()    
MRL2

tiff("Survival_openingMRL.tiff", units = "px", width = 7000, height = 4000, res = 600)
MRL2
dev.off()

#ggplot subset March
#colors

colorPlot = list("#FFCC99","#f58231","#FF3300")
ColorViolin = list("bisque2","bisque2", "darkorange")

sMar <- ggplot(Mar, aes(x = WinterTreatment, y =PercentageAlive , fill= WinterTreatment)) +
  geom_violin(trim = FALSE, color = "#A0A0A0", lwd = 0.4, scale = "count")+
  scale_fill_manual(values=c("moccasin","sandybrown", "tomato")) +
  geom_boxplot(width = 0.15, color = "#000000", fill = colorPlot, lwd = 0.8)+ 
  xlab(NULL) +
  ylab(NULL) + theme_bw() 
  
sMar

tiff("violinsMar_survival.tiff", units = "px", width = 7000, height = 5000, res = 600)
sMar
dev.off()

kruskal.test(Mar$PercentageAlive, Mar$WinterTreatment)
#Kruskal-Wallis chi-squared = 26.106, df = 2, p-value = 2.143e-06


save.image() #to save the whole environment 




