###Survival french winter statistics 
#28.09.23 

#clean everything
rm(list=ls(all=TRUE)); # graphics.off()

#set working directory
setwd("~/Bacherlorthesis/Survivalrate")

#libraries 
library(ggplot2)
library(dplyr)
library(ggsignif)
library(ggpubr)


#get data
survival <- read.csv("Data_for_R_6.csv", header =T, stringsAsFactors = T)

#levels
levels(survival$Opening)
#"January"  "February" "March" 
survival$Opening <- ordered(survival$Opening, levels = c("January","February","March")) #use this to order
levels(survival$WinterTreatment) 
#"FW"   "FW+"  "FW++"

#plots
#survival all
plot(survival$PercentageAlive~as.factor(survival$WinterTreatment),col=c("#FFCC99","#f58231","#FF3300"),xlab= "treatments", ylab = "survival rate (%)")

## normality test
qqnorm(survival$PercentageAlive) 
qqline(survival$PercentageAlive)
bartlett.test(survival$PercentageAlive,survival$WinterTreatment)
#cBartlett's K-squared = 26.948, df = 2, p-value = 1.407e-06
#p-value under 0,05 means that no equal variance -> no ANOVA, we are going to do Kruskall Wallis

#significant test
kruskal.test(survival$PercentageAlive,survival$WinterTreatment)
#Kruskal-Wallis chi-squared = 27.27, df = 2, p-value = 1.198e-06
#there is a significant difference

#post-hoc test: Dunn test
#package needed

library(FSA)

dunnTest(survival$PercentageAlive,survival$WinterTreatment,method="bh")

#plots location and test
plot(survival$PercentageAlive~as.factor(survival$Region))
kruskal.test(survival$PercentageAlive,survival$Region)
#Kruskal-Wallis chi-squared = 1.7541, df = 2, p-value = 0.416
#there is no significdant difference

#plots HatchingSuccess
survival$Region <- factor(survival$Region, levels = c(levels(survival$Region), "Nîmes"))
survival$Region <- factor(survival$Region, levels = c(levels(survival$Region), "Béziers"))

# changing "Nimes" to "Nîmes"
survival$Region[survival$Region == "Nimes"] <- "Nîmes"
survival$Region[survival$Region == "Bezier"] <- "Béziers"
#survival$Region[survival$Region == "Nimes"] <- "po"
#survival$Region <- survival$Region (rename(any_of(c("Nimes"="Nîmes"))))
survival$Region <- factor(survival$Region, levels = c("Nîmes","Carcassone","Béziers"))
plot(survival$HatchingSuccess*100~as.factor(survival$Region), xlab= "Region", ylab = "Hatching Succes (%)")

## normality test
qqnorm(survival$HatchingSuccess) 
qqline(survival$HatchingSuccess)
bartlett.test(survival$HatchingSuccess,survival$WinterTreatment)
#significant test
kruskal.test(survival$HatchingSuccess,survival$WinterTreatment)

#plot Clutchsize
plot(survival$TotalEggSac~as.factor(survival$Region), xlab= "Region", ylab = "Chlutch Size")
## normality test
qqnorm(survival$TotalEggSac) 
qqline(survival$TotalEggSac)
bartlett.test(survival$TotalEggSac,survival$WinterTreatment)
#significant test
kruskal.test(survival$TotalEggSac,survival$WinterTreatment)

#plots weight$survival
plot(survival$weight.living.spiderlings~as.factor(survival$Region),col=c("#FFCC99","#f58231","#FF3300"))
## normality test
qqnorm(survival$weight.living.spiderlings) 
qqline(survival$weight.living.spiderlings)
bartlett.test(survival$weight.living.spiderlings,survival$Region)
#Bartlett's K-squared = 34.197, df = 2, p-value = 3.752e-08
#p-value under 0,05 means that no equal variance -> no ANOVA, we are going to do Kruskall Wallis
#significant test
kruskal.test(survival$weight.living.spiderlings,survival$Region)
#Kruskal-Wallis chi-squared = 1.1527, df = 2, p-value = 0.5619 -> no significant difference


#normality 
shapiro_test <- shapiro.test(Mar$PercentageAlive)
print(shapiro_test)
#NOt normal! 

#now we are subset (for March)
Mar = subset(survival,survival$Opening == "March")
Mar
plot(Mar$PercentageAlive~as.factor(Mar$WinterTreatment),col=c("#FFCC99","#f58231","#FF3300"))

#"#FDBE85", "#CC6B51", "#8B0000"
#geom_point(data = Mar, aes(x = WinterTreatment, y = PercentageAlive, fill = WinterTreatment), shape = 21, size = 5, color = "black")
#axis.text.x = element_blank()

#Violin plot
## Compute medians for each Treatment (to add it to the plot)
median_data <- Mar %>%
  group_by(WinterTreatment) %>%
  summarise(median_value = median(PercentageAlive))


survivalV <- ggplot(Mar, aes(x = WinterTreatment, y = PercentageAlive, fill = WinterTreatment, colour = WinterTreatment)) +
  geom_violin(aes(color = WinterTreatment), alpha = 0.5, lwd = 1.5) + 
  geom_point(aes(fill = WinterTreatment), shape = 21, position = position_jitter(width = 0.2), color = "black", size = 3, stroke = 0.5)+
  scale_colour_manual(values = c("#FDBE85", "#CC6B51", "#8B0000"), guide = FALSE) +
  scale_fill_manual(values = c("#FDBE85", "#CC6B51", "#8B0000")) +  
  geom_point(data = median_data, aes(x = WinterTreatment, y = median_value, fill = WinterTreatment), shape = 22, size = 7, colour = "black", stroke = 1.5) +
  xlab("Treatment") +
  ylab("Survival [%]") + 
  theme_classic() +
  theme(panel.border = element_blank(), 
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        axis.line = element_line(colour = "black"),
        text = element_text(size = 15),
        plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        legend.position = "none")
survivalV

#test
qqnorm(Mar$PercentageAlive) 
qqline(Mar$PercentageAlive)
bartlett.test(Mar$PercentageAlive,Mar$WinterTreatment)
kruskal.test(Mar$PercentageAlive,Mar$WinterTreatment)
#Bartlett's K-squared = 22.84, df = 2, p-value = 1.097e-05
#Kruskal-Wallis chi-squared = 26.106, df = 2, p-value = 2.143e-06

#ggplot survival vs opening 
dodge <- position_dodge(width = 0.5)

B <- ggplot(survival, aes(x= Opening, y= PercentageAlive, fill= WinterTreatment)) +
  geom_violin(trim = FALSE, color = "#A0A0A0", lwd = 0.3, position = dodge) +
  scale_fill_manual(values=c("beige","bisque2", "darkorange")) +
  geom_boxplot(width = 0.1, color = "#000000", lwd = 0.6, position = dodge) +
  scale_fill_manual(values=c("#FFCC99","#f58231","#FF3300")) +
                facet_wrap(~Opening, scales = "free") +
              theme_bw()    
B

#p-value for each Opening
kruskal.test(survival$PercentageAlive,survival$Opening)
#p= 0.05555

tiff("Survival_openingAll.tiff", units = "px", width = 7000, height = 4000, res = 600)
B
dev.off()

#geom_signif(comparisons = list(c("January","February"), c("February","March"), c("January","March")),
            #map_signif_level = c("*"=0.001, "*"=0.01, ""=0.05) 

#subset of MR + Lipids

MRL = subset(survival,survival$Usage == "MR_L")
MR = subset(survival,survival$Usage == "MR")
L = subset(survival,survival$Usage == "L")

#ggplot subset Metabolic Rate
dodge <- position_dodge(width = 0.5)

MRL2 <- ggplot(MRL, aes(x= Opening, y= PercentageAlive, fill= WinterTreatment)) +
  geom_violin(trim = FALSE, color = "#A0A0A0", lwd = 0.3, position = dodge) +
  scale_fill_manual(values=c("beige","bisque2", "darkorange")) +
  geom_boxplot(width = 0.1, color = "#000000", lwd = 0.6, position = dodge) +
  scale_fill_manual(values=c("#FFCC99","#f58231","#FF3300")) +
  facet_wrap(~Opening, scales = "free") +
  theme_bw()    
MRL2

tiff("Survival_openingMRL.tiff", units = "px", width = 7000, height = 4000, res = 600)
MRL2
dev.off()

#ggplot subset March
#colors

colorPlot = list("#FFCC99","#f58231","#FF3300")
ColorViolin = list("bisque2","bisque2", "darkorange")

sMar <- ggplot(Mar, aes(x = WinterTreatment, y =PercentageAlive , fill= WinterTreatment)) +
  geom_violin(trim = FALSE, color = "#A0A0A0", lwd = 0.4, scale = "count")+
  scale_fill_manual(values=c("moccasin","sandybrown", "tomato")) +
  geom_boxplot(width = 0.15, color = "#000000", fill = colorPlot, lwd = 0.8)+ 
  xlab(NULL) +
  ylab(NULL) + theme_bw() 
  
sMar

tiff("violinsMar_survival.tiff", units = "px", width = 7000, height = 5000, res = 600)
sMar
dev.off()

kruskal.test(Mar$PercentageAlive, Mar$WinterTreatment)
#Kruskal-Wallis chi-squared = 26.106, df = 2, p-value = 2.143e-06


save.image() #to save the whole environment 




