##########
#Warmer winters in Southern France project 
#Lilly`s Thesis ## poster ECA/DZG 
#Clean survival after the winter treatments #####
#12.08.24 

rm(list=ls(all=TRUE)); # graphics.off()

#working directory 
setwd("~/brain/Lilly")

#libraries 
library(ggplot2)
library(dplyr)
library(FSA) #dunn test
library(car)


#data 
survival <- read.csv("Data_for_R_6.csv", header =T, stringsAsFactors = T)

##now we are subset (for March)
Mar = subset(survival,survival$Opening == "March")
#take away no hatching sucess egg sacs 
Mar <- Mar[Mar$HatchingSuccess != 0.00000000, ]

#normality? 
shapiro_test <- shapiro.test(Mar$PercentageAlive)
print(shapiro_test)
#NOt normal! 

#Kruskal-Wallis test 
kruskal.test(Mar$PercentageAlive,Mar$WinterTreatment)
#Kruskal-Wallis chi-squared = 23.759, df = 2, p-value = 6.93e-06 

#Post-hoc on 
dunnTest(Mar$PercentageAlive,Mar$WinterTreatment,method ="bh")
# Comparison          Z      P.unadj        P.adj
#1   FW - FW+ 4.2226546 2.414417e-05 7.243251e-05 #significant 
#2   FW - FW++ 4.1924836 2.759170e-05 4.138755e-05 #significant 
#3   FW+ - FW++ 0.0117681 9.906106e-01 9.906106e-01 #not-significant 

#############################################Plot##################
#Violin plot

## Compute medians for each Treatment (to add it to the plot)
median_data <- Mar %>%
  group_by(WinterTreatment) %>%
  summarise(median_value = median(PercentageAlive))


survivalV <- ggplot(Mar, aes(x = WinterTreatment, y = PercentageAlive, fill = WinterTreatment, colour = WinterTreatment)) +
  geom_violin(aes(color = WinterTreatment), alpha = 0.5, lwd = 1.5) + 
  geom_point(aes(fill = WinterTreatment), shape = 21, position = position_jitter(width = 0.2), color = "black", size = 4, stroke = 0.5)+
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000"), guide = FALSE) +
  scale_fill_manual(values = c("#FDBE85", "#E66101", "#8B0000")) +  
  geom_point(data = median_data, aes(x = WinterTreatment, y = median_value, fill = WinterTreatment), shape = 22, size = 7, colour = "black", stroke = 1.5) +
  xlab(NULL) +
  ylab("Survival proportion") + 
  theme_classic() +
  theme(legend.position = "none", 
        axis.text.x =element_text(size = 18, color = "black"),
        axis.text.y = element_text(size = 16, color = "black"),  # Sets y-axis numbers to bigger and black
        axis.title.y = element_text(size = 16, color = "black"))
survivalV

#"#FDBE85", "#E66101", "#8B0000" Chosen colors 

#####plot for publication

surv <- ggplot(Mar, aes(x = WinterTreatment, y = PercentageAlive, fill = WinterTreatment, colour = WinterTreatment)) +
  geom_violin(aes(color = WinterTreatment), alpha = 0.5, lwd = 1.5, width = 0.4) + 
  geom_point(aes(fill = WinterTreatment), shape = 21, width = 0.05, position = position_jitter(width = 0.1), alpha = 0.8, size = 4, stroke = 1)+
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000"), guide = FALSE) +
  scale_fill_manual(values = c("#FDBE85", "#E66101", "#8B0000")) +  
  geom_point(data = median_data, aes(x = WinterTreatment, y = median_value, fill = WinterTreatment), shape = 22, size = 7, colour = "black", stroke = 1.5) +
  xlab(NULL) +
  ylab("Survival proportion") + 
  theme_classic() +
  theme(legend.position = "none", 
        axis.text.x =element_text(size = 14, color = "black"),
        axis.text.y = element_text(size = 16, color = "black"),  # Sets y-axis numbers to bigger and black
        axis.title.y = element_text(size = 16, color = "black"))
surv

#####Transparent ######

VioTran<-ggplot(Mar, aes(x = WinterTreatment, y = PercentageAlive, fill = WinterTreatment, colour = WinterTreatment)) +
  geom_violin(aes(color = WinterTreatment), alpha = 0.5, lwd = 1.5, width = 0.4) + 
  geom_point(aes(fill = WinterTreatment), shape = 21, width = 0.05, position = position_jitter(width = 0.1), alpha = 0.8, size = 4, stroke = 1)+
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000"), guide = FALSE) +
  scale_fill_manual(values = c("#FDBE85", "#E66101", "#8B0000")) +  
  geom_point(data = median_data, aes(x = WinterTreatment, y = median_value, fill = WinterTreatment), shape = 22, size = 7, colour = "black", stroke = 1.5) +
  xlab(NULL) +
  ylab("Survival proportion") + 
  theme_classic() +
  theme(legend.position = "none", 
  axis.title = element_text(size = 14, color = "white"),  # Adjust size as needed
  axis.text = element_text(size = 16, color = "white"),  # Adjust size as needed
  legend.title = element_blank(),
  legend.text = element_text(size = 16, color = "white"),  # Adjust size as needed
  panel.background = element_rect(fill = "transparent", colour = NA),
  plot.background = element_rect(fill = "transparent", colour = NA),
  axis.ticks = element_line(color = "white"),
  legend.background = element_rect(fill = "transparent", color = NA),
  axis.line.x = element_line(color = "white"),
  axis.line.y = element_line(color = "white"))
VioTran

# Save the plot as a PNG with a transparent background and high resolution
ggsave("SurvivalEnd_transparent.png", plot = VioTran, bg = "transparent", dpi = 300, width = 7, height = 5)  # High quality

#### model end of winter ###########

Mar$PercentageAlive <- Mar$PercentageAlive/ 100 

length(Mar$PercentageAlive) #for the n


Mar$Region

model <- glmmTMB(PercentageAlive ~ WinterTreatment + scale(TotalEggSac) + (1|Region),
                  family = ordbeta(), 
                  data = Mar)

#check assumptions
obj <- simulateResiduals(model, plot = F)
plot(obj, quantreg = F)
Anova(model, type="III")

#post hoc posthoc with Tukey correction for the model 
emm <- emmeans(model, specs = pairwise ~ WinterTreatment)
posthoc_results <- summary(emm$contrasts)
summary(emm$contrasts, adjust = "tukey") #this is the p value between the treatments that you report 

