#Temperatures for bachelor project: climate change in French Egg sacs 
#Carolina 07.22
#edited 21.03.24 

setwd("~/brain/Lilly") #put your working directory
tempHot<-read.csv("Temperature_FrenchClimate_22.csv", header = T,stringsAsFactors=T) # the data 

pdf("temperature_plot_vertical.pdf", width = 6, height = 10)

par(mfrow = c(3, 1),  # 3 plots in one row
   mar = c(5, 5, 4, 1) + 0.1,  # Adjust left margin here; it's the second value in the vector
   cex.lab = 1.3,  # Size of axis labels (x and y)
   cex.axis = 2, # Size of axis tick labels
   las = 2) #perpendicular to axis  

#####Temperature#####
#par(mfrow=c(1,3)) # here you change the number of rows and columns for the figure, in this case is 3 plots in the same row.

####Southern France normal#### FW
months<-c("Aug","Sept","Oct","Oct","Nov","Nov","Dec","Dec","Jan","Jan","Feb","Feb","Mar","Mar","Apr","Apr")
#monthN<-c("1-31","16-30","1-15","16-31","1-15","16-30","1-15","16-31","1-15","16-31","1-15","16-28","1-15","16-31","1-15","16-30")

# Plot for Southern France normal scenario
plot(tempHot$SF_Day ~ tempHot$MonthNumber, type = "b", ylim = c(0, 31),
     ylab = "", xlab = "",
     xaxt = "n", col = "#FDBE85", pch = 1, cex = 1.5, lwd = 2, cex.lab = 1.5)
lines(tempHot$SF_Night ~ tempHot$MonthNumber, type = "b", pch = 2, col = "#FDBE85", cex = 1.5, lwd = 2)
#axis(1, at = 1:16, labels = months, cex.axis = 0.9)
#axis(1, pos = -13, at = 1:16, labels = monthN, tck = 0, cex.axis = 1, lty = 0)
# Adding blue horizontal lines at 10°C and 20°C
abline(h = 10, col = "blue", lwd = 2, lty = 2)  # Dotted line at 10°C
abline(h = 20, col = "blue", lwd = 2, lty = 2)  # Dotted line at 20°C

##### French winter + 3.7°C ######### FW+

months<-c("Aug","Sept","Oct","Oct","Nov","Nov","Dec","Dec","Jan","Jan","Feb","Feb","Mar","Mar","Apr","Apr")
#monthN<-c("1-31","16-30","1-15","16-31","1-15","16-30","1-15","16-31","1-15","16-31","1-15","16-28","1-15","16-31","1-15","16-30")

plot(tempHot$SF3_Day~tempHot$MonthNumber, type="b",ylim=c(0,31),ylab="",xlab="",xaxt="n",col="#E66101",pch = 1, cex = 1.5, lwd = 2, cex.lab = 1.5)
lines(tempHot$SF3_Night~tempHot$MonthNumber,type="b",pch=2,col="#E66101",cex = 1.5, lwd = 2)
#axis(1, at = 1:16, labels = months, cex.axis = 0.9)
#axis(1, pos = -13, at = 1:16, labels = monthN, tck = 0, cex.axis = 1, lty = 0)
# Adding blue horizontal lines at 10°C and 20°C
abline(h = 10, col = "blue", lwd = 2, lty = 2)  # Dotted line at 10°C
abline(h = 20, col = "blue", lwd = 2, lty = 2)  # Dotted line at 20°C

####### French winter ++ 4.8?C ######### FW++

months<-c("Aug","Sept","Oct","Oct","Nov","Nov","Dec","Dec","Jan","Jan","Feb","Feb","Mar","Mar","Apr","Apr")
#monthN<-c("1-31","16-30","1-15","16-31","1-15","16-30","1-15","16-31","1-15","16-31","1-15","16-28","1-15","16-31","1-15","16-30")


plot(tempHot$SF4_Day~tempHot$MonthNumber, type="b",ylim=c(0,31),ylab="",xlab="",xaxt="n",col="#8B0000",pch = 1, cex = 1.5, lwd = 2, cex.lab = 1.5)
lines(tempHot$SF4_Night~tempHot$MonthNumber,type="b",pch=2,col="#8B0000",cex = 1.5, lwd = 2)
axis(1, at = 1:16, labels = months, cex.axis = 1.3)
#axis(1, pos = -13, at = 1:16, labels = monthN, tck = 0, cex.axis = 1, lty = 0)
# Adding blue horizontal lines at 10°C and 20°C
abline(h = 10, col = "blue", lwd = 2, lty = 2)  # Dotted line at 10°C
abline(h = 20, col = "blue", lwd = 2, lty = 2)  # Dotted line at 20°C

dev.off()

######Transparent ######

# the data 
tempHot <- read.csv("Temperature_FrenchClimate_22.csv", header = TRUE, stringsAsFactors = TRUE) 

# Set up PNG device with transparent background
png("temperature_plot_2_T.png", width = 12, height = 6, units = "in", res = 300, bg = "transparent")

# Set graphical parameters with white text
par(mfrow = c(1, 3),  # 3 plots in one row
    mar = c(5, 5, 4, 1) + 0.1,  # Adjust margins
    cex.lab = 2,  # Size of axis labels
    cex.axis = 1.5, # Size of axis tick labels
    las = 2, #perpendicular to axis
    col.axis = "white", # White axis text
    col.lab = "white", # White axis labels
    col.main = "white", # White main title
    fg = "white", # White border and axes
    bg = "transparent") # Transparent background

#Temperature 
months <- c("Aug","Sept","Oct","Oct","Nov","Nov","Dec","Dec","Jan","Jan","Feb","Feb","Mar","Mar","Apr","Apr")
monthN <- c("1-31","16-30","1-15","16-31","1-15","16-30","1-15","16-31","1-15","16-31","1-15","16-28","1-15","16-31","1-15","16-30")

#### Southern France normal #### FW
plot(tempHot$SF_Day ~ tempHot$MonthNumber, type = "b", ylim = c(0, 31),
     ylab = "Temperature (°C)", xlab = "",
     xaxt = "n", col = "#FDBE85", pch = 1, cex = 2, lwd = 2, cex.lab = 2)
lines(tempHot$SF_Night ~ tempHot$MonthNumber, type = "b", pch = 2, col = "#FDBE85", cex = 2, lwd = 2)
axis(1, at = 1:16, labels = months, cex.axis = 1.5, col.axis = "white")
axis(1, pos = -13, at = 1:16, labels = monthN, tck = 0, cex.axis = 1, lty = 0, col.axis = "white")
abline(h = 10, col = "skyblue", lwd = 2, lty = 2)
abline(h = 20, col = "skyblue", lwd = 2, lty = 2)

##### French winter + 3.7°C ######### FW+
plot(tempHot$SF3_Day ~ tempHot$MonthNumber, type = "b", ylim = c(0, 31),
     ylab = "", xlab = "", xaxt = "n", col = "#E66101", 
     pch = 1, cex = 2, lwd = 2, cex.lab = 2)
lines(tempHot$SF3_Night ~ tempHot$MonthNumber, type = "b", pch = 2, col = "#E66101", cex = 2, lwd = 2)
axis(1, at = 1:16, labels = months, cex.axis = 1.5, col.axis = "white")
axis(1, pos = -13, at = 1:16, labels = monthN, tck = 0, cex.axis = 1, lty = 0, col.axis = "white")
abline(h = 10, col = "skyblue", lwd = 2, lty = 2)
abline(h = 20, col = "skyblue", lwd = 2, lty = 2)

# French winter ++ 4.8°C #
plot(tempHot$SF4_Day ~ tempHot$MonthNumber, type = "b", ylim = c(0, 31),
     ylab = "", xlab = "", xaxt = "n", col = "#8B0000", 
     pch = 1, cex = 2, lwd = 2, cex.lab = 2)
lines(tempHot$SF4_Night ~ tempHot$MonthNumber, type = "b", pch = 2, col = "#8B0000", cex = 2, lwd = 2)
axis(1, at = 1:16, labels = months, cex.axis = 1.5, col.axis = "white")
axis(1, pos = -13, at = 1:16, labels = monthN, tck = 0, cex.axis = 1, lty = 0, col.axis = "white")
abline(h = 10, col = "skyblue", lwd = 2, lty = 2)
abline(h = 20, col = "skyblue", lwd = 2, lty = 2)

# Close the PNG device
dev.off()

###### normal ######
# Set up PNG device 
pdf("temperature_plot.pdf", width = 12, height = 6)

# Set graphical parameters with white text
par(mfrow = c(1, 3),  # 3 plots in one row
    mar = c(5, 5, 4, 1) + 0.1,  # Adjust margins
    cex.lab = 2,  # Size of axis labels
    cex.axis = 1.5, # Size of axis tick labels
    las = 2, #perpendicular to axis
    col.axis = "black", # White axis text
    col.lab = "black", # White axis labels
    col.main = "black", # White main title
    fg = "black") 

#Temperature 
months <- c("Aug","Sept","Oct","Oct","Nov","Nov","Dec","Dec","Jan","Jan","Feb","Feb","Mar","Mar","Apr","Apr")
#monthN <- c("1-31","16-30","1-15","16-31","1-15","16-30","1-15","16-31","1-15","16-31","1-15","16-28","1-15","16-31","1-15","16-30")

#### Southern France normal #### FW
plot(tempHot$SF_Day ~ tempHot$MonthNumber, type = "b", ylim = c(0, 31),
     ylab = "Temperature (°C)", xlab = "",
     xaxt = "n", col = "#FDBE85", pch = 1, cex = 2, lwd = 2, cex.lab = 2)
lines(tempHot$SF_Night ~ tempHot$MonthNumber, type = "b", pch = 2, col = "#FDBE85", cex = 2, lwd = 2)
axis(1, at = 1:16, labels = months, cex.axis = 1.5)
axis(1, pos = -13, at = 1:16, labels = monthN, tck = 0, cex.axis = 1, lty = 0)
abline(h = 10, col = "skyblue", lwd = 2, lty = 2)
abline(h = 20, col = "skyblue", lwd = 2, lty = 2)

##### French winter + 3.7°C ######### FW+
plot(tempHot$SF3_Day ~ tempHot$MonthNumber, type = "b", ylim = c(0, 31),
     ylab = "", xlab = "", xaxt = "n", col = "#E66101", 
     pch = 1, cex = 2, lwd = 2, cex.lab = 2)
lines(tempHot$SF3_Night ~ tempHot$MonthNumber, type = "b", pch = 2, col = "#E66101", cex = 2, lwd = 2)
axis(1, at = 1:16, labels = months, cex.axis = 1.5)
axis(1, pos = -13, at = 1:16, labels = monthN, tck = 0, cex.axis = 1, lty = 0)
abline(h = 10, col = "skyblue", lwd = 2, lty = 2)
abline(h = 20, col = "skyblue", lwd = 2, lty = 2)

# French winter ++ 4.8°C #
plot(tempHot$SF4_Day ~ tempHot$MonthNumber, type = "b", ylim = c(0, 31),
     ylab = "", xlab = "", xaxt = "n", col = "#8B0000", 
     pch = 1, cex = 2, lwd = 2, cex.lab = 2)
lines(tempHot$SF4_Night ~ tempHot$MonthNumber, type = "b", pch = 2, col = "#8B0000", cex = 2, lwd = 2)
axis(1, at = 1:16, labels = months, cex.axis = 1.5)
axis(1, pos = -13, at = 1:16, labels = monthN, tck = 0, cex.axis = 1, lty = 0)
abline(h = 10, col = "skyblue", lwd = 2, lty = 2)
abline(h = 20, col = "skyblue", lwd = 2, lty = 2)

# Close the PNG device
dev.off()




