########### Bachelor Arbeit R Statistik ##############
################### Ebbe Nürnberg ####################
###################### 11.06.24 ######################
####12.08.24 ###

rm(list=ls(all=TRUE)); # graphics.off()

setwd("~/brain/ebbe")

#libraries
library(dplyr)
library(ggplot2)
library(DHARMa)
library (car) 
library(emmeans)
library(dunn.test)

#Data
Datab <- read.csv("R_Data.csv",header = T, stringsAsFactors=T, dec = ".", sep = ";")

#####Untergruppieren####
###Nach Temperaturbehandlung (Treatment)

#FW
subset_FW<-subset(Data, Data$Treatment=="FW")
#FW+
subset_FWp<-subset(Data, Data$Treatment=="FW+")
#FW++
subset_FWpp<-subset(Data, Data$Treatment=="FW++")

###Nach Herkunft (Origin)
#Carcassonne
Carcassonne<-subset(Data, Data$Origin=="Carcassonne")
#Béziers
Béziers<-subset(Data, Data$Origin=="Beziers")
#Nîmes
Nîmes<-subset(Data, Data$Origin=="Nimes")

######Test auf Normalverteilung
shapiro.test(Data$PB) #normal
shapiro.test(Data$OPV) #nicht normal
shapiro.test(Data$conditionindex) #normal
shapiro.test(Data$Mother) #nicht normal 
shapiro.test(Data$ClutchSize) #nicht normal

#Nicht-parametrische Tests
kruskal.test(ClutchSize ~ Origin, data = Data)
kruskal.test(Mother ~ Origin, data = Data)

kruskal.test(Data$OPV ~ Data$Treatment)
dunn_result <- dunn.test(Data$OPV, Data$Treatment, method = "bonferroni")
kruskal.test(conditionindex ~ Origin, data = Data)

###Körperkondition###
attach(Data)

#einfaches lineares Modell
lm_model <- lm(OPV_log~PB_log)  
summary(lm(OPV_log~PB_log))
Data$conditionindex <-lm(OPV_log~PB_log)$residuals


### GLM Körperkondition ###
model_glm <- glm(conditionindex ~ Treatment + Mother + ClutchSize,  
                 data = Data,
                 family = gaussian())
summary(model_glm)
Anova(model_glm, type = "III")

#Annahmen Test
obj <- simulateResiduals(model_glm, plot = F)
plot(obj, quantreg = F)
# run posthoc with Tukey correction for the model  
emm <- emmeans(model_glm, specs = pairwise ~ Treatment)
posthoc_results <- summary(emm$contrasts)
summary(emm$contrasts, adjust = "tukey")


#plot  Körperkondition gegen Treatment

median_data <- Data %>%
  group_by(Treatment) %>%
  summarise(median_value = median(conditionindex))

bd <- ggplot(Data, aes(x = Treatment, y = conditionindex, fill= Treatment, colour = Treatment)) +
  geom_violin(aes(color = Treatment), alpha = 0.4, lwd = 1.5, width = 0.4) +
  geom_point(aes(fill = Treatment), shape = 21, width = 0.05, position = position_jitter(width = 0.1), alpha = 0.8, size = 4, stroke = 1) +
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000"), guide = FALSE) +
  scale_fill_manual(values = c("#FDBE85", "#E66101", "#8B0000")) + 
  geom_point(data = median_data, aes(x = Treatment, y = median_value, fill = Treatment), shape = 22, size = 7, colour = "black", stroke = 1.5) +
  labs(x = NULL , y = "Body condition Index") +
  labs(fill = "Temperaturbehandlung") +  # Änderung der Legendenüberschrift
  theme_classic() +
  theme(legend.position = "none", 
        axis.text.x =element_text(size = 14, color = "black"),
        axis.text.y = element_text(size = 16, color = "black"),  # Sets y-axis numbers to bigger and black
        axis.title.y = element_text(size = 16, color = "black"))
bd

######transparent#####

bdTran <- ggplot(Data, aes(x = Treatment, y = conditionindex, fill= Treatment, colour = Treatment)) +
  geom_violin(aes(color = Treatment), alpha = 0.4, lwd = 1.5, width = 0.4) +
  geom_point(aes(fill = Treatment), shape = 21, width = 0.05, position = position_jitter(width = 0.1), alpha = 0.8, size = 4, stroke = 1) +
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000"), guide = FALSE) +
  scale_fill_manual(values = c("#FDBE85", "#E66101", "#8B0000")) + 
  geom_point(data = median_data, aes(x = Treatment, y = median_value, fill = Treatment), shape = 22, size = 7, colour = "black", stroke = 1.5) +
  labs(x = NULL , y = "Body condition Index") +
  labs(fill = "Temperaturbehandlung") +  # Änderung der Legendenüberschrift
  theme_classic() +
  theme(legend.position = "none", 
      axis.title = element_text(size = 14, color = "white"),  # Adjust size as needed
      axis.text = element_text(size = 16, color = "white"),  # Adjust size as needed
      legend.title = element_blank(),
      legend.text = element_text(size = 16, color = "white"),  # Adjust size as needed
      panel.background = element_rect(fill = "transparent", colour = NA),
      plot.background = element_rect(fill = "transparent", colour = NA),
      axis.ticks = element_line(color = "white"),
      legend.background = element_rect(fill = "transparent", color = NA),
      axis.line.x = element_line(color = "white"),
      axis.line.y = element_line(color = "white"))
bdTran

# Save the plot as a PNG with a transparent background and high resolution
ggsave("BodyCondition_transparent.png", plot = bdTran, bg = "transparent", dpi = 300, width = 7, height = 5)  # High quality

