##### Body condition Index #####
###Ebbe's bachelor 
## by COM 
#10.08.25

rm(list=ls(all=TRUE)); # graphics.off()

setwd("~/brain/ebbe")

#libraries
library(dplyr)
library(ggplot2)
library(DHARMa) #checking assumtions 
library (car) 
library(glmmTMB) #for the model 
library(emmeans)
library(dunn.test)

#Data
Data <- read.csv("R_Data.csv",header = T, stringsAsFactors=T, dec = ".", sep = ";")

str(Data)

Data$ClutchSize <-as.numeric(Data$ClutchSize)

######Test auf Normality
shapiro.test(Data$PB_log) #normal
shapiro.test(Data$OPV_log) #normal
shapiro.test(Data$conditionindex) #normal
shapiro.test(Data$Mother) #not normal 
shapiro.test(Data$ClutchSize) #not normal


#### Body condition index #####

lm_model <- lm(OPV_log~PB_log)  
summary(lm(OPV_log~PB_log))
Data$conditionindex <-lm(OPV_log~PB_log)$residuals 

length(Data$conditionindex) #81

#### plot of linear regression between the mass and the body size

ggplot(Data, aes(x = OPV_log, y = PB_log, color = Treatment)) +
  geom_point() +
  geom_smooth(method = "lm", # Linear regression
              se = TRUE,          # Hide confidence interval (set `se=TRUE` to show)
              linewidth = 0.8,
              color = "black",
              aes(group = 1)) +      # Adjust line thickness
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000")) + 
  theme_classic()+
  theme(axis.ticks = element_line(color = "black"),
        axis.text.y = element_text(size = 14, color = "black"),# Sets y-axis numbers to bigger and black
        axis.text.x = element_text(size = 14, color = "black"),
        axis.title.y = element_text(size = 16, color = "black"),
        axis.title.x = element_text(size = 16, color = "black"))

##### model ####

model <- glmmTMB(conditionindex ~ Treatment + scale(Mother) + scale(ClutchSize) + (1 |SpiderCode), 
                 data = Data,
                 family = gaussian()) #this is the one 

modelSimple<- glmmTMB(conditionindex ~ Treatment + (1 |SpiderCode), 
                      data = Data,
                      family = gaussian())

summary(modelSimple)

AIC(model, modelSimple)

#check assumtions 
obj <- simulateResiduals(model, plot = F)
plot(obj, quantreg = F)
Anova(model, type = "III")
#glmm x2= 34.80, df= 2, p= 2.769e-08 ***

# run posthoc with Tukey correction for the model  
emm <- emmeans(model, specs = pairwise ~ Treatment)
posthoc_results <- summary(emm$contrasts)
summary(emm$contrasts, adjust = "tukey")

#contrast       estimate     SE df t.ratio p.value
#FW - (FW+)       0.4006 0.0731 71   5.481  <.0001
#FW - (FW++)      0.3649 0.0827 71   4.411  0.0001
#(FW+) - (FW++)  -0.0357 0.0822 71  -0.434  0.9014

##### plot for publication ####

#median_data <- Data %>%
  #group_by(Treatment) %>%
  #summarise(median_value = median(conditionindex))

summary_stats <- Data %>%
  group_by(Treatment) %>%
  summarise(mean = mean(conditionindex), sd = sd(conditionindex))

# Calculate mean plus standard deviation
summary_stats <- summary_stats %>%
  mutate(upper = mean + sd, lower = mean - sd)


bd <- ggplot(Data, aes(x = Treatment, y = conditionindex, fill= Treatment, colour = Treatment)) +
  geom_violin(aes(color = Treatment), alpha = 0.4, lwd = 1.5, width = 0.4) +
  geom_point(aes(fill = Treatment), shape = 21, width = 0.05, position = position_jitter(width = 0.1), alpha = 0.8, size = 4, stroke = 1) +
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000"), guide = FALSE) +
  scale_fill_manual(values = c("#FDBE85", "#E66101", "#8B0000")) + 
  geom_errorbar(data = summary_stats, aes(x = Treatment, ymin = lower, ymax = upper),
              width = 0.2, linewidth = 0.8, color = "black", inherit.aes = FALSE) +
  geom_point(data = summary_stats, aes(x = Treatment, y = mean, fill = Treatment), shape = 22, size = 7, color = "black", stroke = 1.5) +
  labs(x = NULL , y = "Body condition Index") +
  theme_classic() +
  theme(legend.position = "none", 
        axis.text.x =element_text(size = 14, color = "black"),
        axis.text.y = element_text(size = 16, color = "black"),  # Sets y-axis numbers to bigger and black
        axis.title.y = element_text(size = 16, color = "black"))
bd



 

######transparent#####

bdTran <- ggplot(Data, aes(x = Treatment, y = conditionindex, fill= Treatment, colour = Treatment)) +
  geom_violin(aes(color = Treatment), alpha = 0.4, lwd = 1.5, width = 0.4) +
  geom_point(aes(fill = Treatment), shape = 21, width = 0.05, position = position_jitter(width = 0.1), alpha = 0.8, size = 4, stroke = 1) +
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000"), guide = FALSE) +
  scale_fill_manual(values = c("#FDBE85", "#E66101", "#8B0000")) + 
  geom_point(data = median_data, aes(x = Treatment, y = median_value, fill = Treatment), shape = 22, size = 7, colour = "black", stroke = 1.5) +
  labs(x = NULL , y = "Body condition Index") +
  theme_classic() +
  theme(legend.position = "none", 
        axis.title = element_text(size = 14, color = "white"),  # Adjust size as needed
        axis.text = element_text(size = 16, color = "white"),  # Adjust size as needed
        legend.title = element_blank(),
        legend.text = element_text(size = 16, color = "white"),  # Adjust size as needed
        panel.background = element_rect(fill = "transparent", colour = NA),
        plot.background = element_rect(fill = "transparent", colour = NA),
        axis.ticks = element_line(color = "white"),
        legend.background = element_rect(fill = "transparent", color = NA),
        axis.line.x = element_line(color = "white"),
        axis.line.y = element_line(color = "white"))
bdTran

# Save the plot as a PNG with a transparent background and high resolution
ggsave("BodyCondition_transparent.png", plot = bdTran, bg = "transparent", dpi = 300, width = 7, height = 5)  # High quality


###### Origin? 

ggplot(Data, aes(x = Origin , y = conditionindex, color = Treatment)) +
  geom_point() +
  #geom_smooth(method = "lm", color = "black", se = TRUE) + # Adds a single regression line
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000")) + 
  theme_classic()

anova_origin <- aov(conditionindex ~ Origin, data = Data)
summary(anova_origin) #not significant
TukeyHSD(anova_origin)


###mother by region 

shapiro.test(Data$Mother)
#not normal 

ggplot(Data, aes(x = Origin , y = Mother, color = Treatment)) +
  geom_point() +
  #geom_smooth(method = "lm", color = "black", se = TRUE) + # Adds a single regression line
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000")) + 
  theme_classic()

kruskal.test(Data$Mother ~  Data$Origin )
dunnTest(Data$Mother ~  Data$Origin)

### mother vs spiderling size 

Data$PB_log

ggplot(Data, aes(x = Mother , y = PB_log, color = Origin)) +
  geom_point() +
  geom_smooth(method = "lm", color = "black", se = TRUE) + # Adds a single regression line
  scale_colour_manual(values = c("#FDBE85", "#E66101", "#8B0000")) + 
  theme_classic()

model <- lm(PB_log ~ Mother, data = data)
summary(model) #not significant 
