###########Bachelor Thesis Statistics##############

#Achtung es sind nicht alle OPV Werte richtig. Stefan reicht 1 (30-0006) Werte nach. 
##dann nochmal rechnen!

## Beispiel mit read.csv
#df <- read.csv("deine_tabelle.csv", na.strings = c("", "NA", "missing"))
#alle elemente die nichts, NA oder missing heissen werden nun als NA in R ausgegeben.
#Man muss immer den Speicherpfad angeben!


#Datei laden
Data <- read.csv("/Users/Ebbe/Desktop/Ebbes Dateien/Uni Greifswald/Bachelorarbeit/R Statistic/Statistics/R_Data.csv", 
                 sep = ";", na.strings = c(""), nrows = 82,
                 dec = ",",  # Hier füge das Dezimaltrennzeichen hinzu
                 colClasses = c("character", "character", "character", "character", "numeric", "numeric", "numeric", "numeric", "numeric", "numeric", "numeric"))


#Speicherpfad herausfinden:
getwd() 

View(Data)
Data

install.packages("ggplot2")
library(ggplot2)



#---------------------------------------------------------------------------#

#####################  Daten Untersuchen ####################################

#---------------------------------------------------------------------------#

#1 Daten untersuchen
#1.1 Struktur überblicken
summary(Data)
str(Data)


###############################sub-grouping####################################
#Nach Treatment
#Nur FW
subset_FW<-subset(Data, Data$Treatment=="FW")
View(subset_FW)
#Nur FW+
subset_FWp<-subset(Data, Data$Treatment=="FW+")
View(subset_FWp)
#Nur FW++
subset_FWpp<-subset(Data, Data$Treatment=="FW++")
View(subset_FWpp)

#Nach Origin
#Nur Carcassonne
Carcassonne<-subset(Data, Data$Origin=="Carcassonne")
View(Carcassonne)
#Nur Béziers
Béziers<-subset(Data, Data$Origin=="Béziers")
View(Béziers)
#Nur Nîmes
Nîmes<-subset(Data, Data$Origin=="Nîmes")
View(Nîmes)





##################################################################
 ##############  1) Ratio Index nach Jakob et Al. ###############
 ##############               OPV / PB            ###############
##################################################################



#Normalverteilt?
shapiro.test(Data$RatioIndex)
#p=0,01329 < 0,05 Nicht normalverteilt

#Varianzhomogenität?
install.packages("car")
library(car)
leveneTest(RatioIndex ~ Treatment, data = Data)
#p=0,8533 > 0,05 nicht signifikant also homogen! 

kruskal.test(RatioIndex ~ Treatment, data = Data)
#p=6,072e-08 << 0,05 Es gibt signifikante Unterschiede

# Installieren Sie das 'dunn.test' Paket, wenn Sie es noch nicht installiert haben
install.packages("dunn.test")

# Laden Sie das 'dunn.test' Paket
library(dunn.test)

# Durchführung des Dunn-Tests
dunn_result <- dunn.test(Data$RatioIndex, Data$Treatment, method = "bonferroni")

# Anzeigen der Ergebnisse
print(dunn_result)



# Scatterplot for Ratio Index Hier mit Temp Diff
ggplot(Data, aes(x = TempDiff, y = RatioIndex)) +
  geom_point() +
  labs(x = "Temperatur verschoben um (° C)", y = "Körperkondition (Index)", title = "Ratio Index nach Jakob et. Al.") +
  geom_smooth(method = lm) +         # Trendlinie ist nich möglich, da Nummer caracter ist. Trendlinien gehen nur wenn beide variablen numeric sind
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust = 1)) #hier drehe ich die achsenbeschriftung 

# Scatterplot for Ratio Index Hier mit Nummernumeric
ggplot(Data, aes(x = Spiderling, y = RatioIndex)) +
  geom_point() +
  labs(x = "Spiderling", y = "Körperkondition (OPV/PB)", title = "Ratio Index nach Jakob et. Al.") +
  geom_smooth(method = lm) +         # Trendlinie ist nich möglich, da Nummer caracter ist. Trendlinien gehen nur wenn beide variablen numeric sind
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust = 1)) #hier drehe ich die achsenbeschriftung 


# Ratio Index im Boxplot gegen Treatment
ggplot(Data, aes(y = RatioIndex, x = Treatment)) + 
  geom_boxplot() +
  labs(y = bquote("Bodycondition (OVP/PB)"), title = "Ratio Index nach Jakob et. Al.")





#######################################################################
##############. 2)   Untersuchung OPV.    ################################
#######################################################################



# Erstellen des OPV Scatterplot mit ggplot2
ggplot(Data, aes(x = NummerNumeric, y = OPV)) +
  geom_point() +
  labs(x = "Spiderling", y = "OPV", title = "Punktdiagramm der OPV") +
  geom_smooth(method = lm) +         # Trendlinie ist nich möglich, da Nummer caracter ist. Trendlinien gehen nur wenn beide variablen numeric sind
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust = 1)) #hier drehe ich die achsenbeschriftung 
#we can see a trend!

### Boxplott von OPV/Treatment machen
OPVbp <- ggplot(Data, aes(y = OPV, x = Treatment)) + 
  geom_boxplot() +
  labs(y = bquote("Opisthosoma Volumen ("~µm^3~")"), title = "Boxplot OVP")

print(OPVbp)


mean(subset_FW$OPV)
mean(subset_FWp$OPV)
mean(subset_FWpp$OPV)

###### Test auf Normalverteilung OVP

### FW$OPV
shapiro_FW <- shapiro.test(subset_FW$OPV)
# Ausgabe des Testergebnisses
print(shapiro_FW)
#p-value = 0.9847 >0,05 -> normalverteilt

### FWp$OPV
shapiro_FWp <- shapiro.test(subset_FWp$OPV)
# Ausgabe des Testergebnisses
print(shapiro_FWp)
#p-value = 0.3188 >0,05 -> normalverteilt

### FWpp$OPV
shapiro_FWpp <- shapiro.test(subset_FWpp$OPV)
# Ausgabe des Testergebnisses
print(shapiro_FWpp)
#p-value = 0.004393 < 0,05 -> nicht normalverteilt

### Normalverteilung insgesamt:
shapiro_OPV <- shapiro.test(Data$OPV)
print(shapiro_OPV)
#p=0,01179 < 0,05 nicht normalverteilt.
hist(Data$OPV)

#OPV
# Kruskal-Wallis-Test durchführen
kruskal_result <- kruskal.test(Data$OPV ~ Data$Treatment)

# Zusammenfassung der Kruskal-Wallis-Ergebnisse anzeigen
kruskal_result
#p=2.172e-08 <<0,05
#Teststatistik: Die Teststatistik (chi-squared) ist relativ hoch, was darauf hindeutet, dass es Unterschiede in den Rängen zwischen den Gruppen gibt.
#P-Wert: Der P-Wert ist extrem klein (2.172e-08), was darauf hindeutet, dass die beobachteten Unterschiede in den Rängen höchstwahrscheinlich nicht auf Zufall beruhen. 
#Ergebnis: es gibt statistische Evidenz dafür, dass es signifikante Unterschiede in den Opisthosomavolumina zwischen den Treatment Groups gibt.

# Installieren Sie das 'dunn.test' Paket, wenn Sie es noch nicht installiert haben
# install.packages("dunn.test")

# Laden Sie das 'dunn.test' Paket
library(dunn.test)

# Durchführung des Dunn-Tests
dunn_result <- dunn.test(Data$OPV, Data$Treatment, method = "bonferroni")

# Anzeigen der Ergebnisse
print(dunn_result)
#FW/FW+ *
#FW/FW++ *
#FW+/FW++ 

##########################################################################

########### Connection between OPV and Mothersize ########

#Normaldistribution?
shapiro.test(Data$Mother)
#p=5.361e-05 << 0,05 Muttergröße not Normal distributed
hist(Data$Mother)
#OPV not Normal distributed

#not normaldistirbuted we call a spearman test.
correlation_spearman <- cor.test(Data$OPV, Data$Mother, method = "spearman")
print(correlation_spearman)
#WARNING es gibt anscheinend Rangbindungen, also gleiche werte. Damit kann Spearman nicht umgehen. 
## Kendall's Tau-Test ist gegen Rangbindung robuster! 
#durchführen
correlation_kendall <- cor.test(Data$OPV, Data$Mother, method = "kendall")
print(correlation_kendall)
#p=0,9449 > 0,05 No Correlation!

# simple linear Regression
lm_model <- lm(OPV ~ Mother, data = Data)
summary(lm_model)
#p=0,9152 > 0,05 no correlation!


ggplot(Data, aes(x = Mother, y = OPV)) +
  geom_point() +
  labs(x = "Mothersize (µm)", y = bquote("OPV ("~µm^3~")"), title = "Punktdiagramm OPV/Mothersize") +
  geom_smooth(method = lm, se = TRUE) 

summary(lm_model)$r.squared



##########################################################################



########### Connection between OPV and PB ########

shapiro.test(Data$PB)
#p=0,8079 > 0,05 NORMAL DISTRIBUTED

# Spearman-Rangkorrelationstest durchführen
correlation_spearman <- cor.test(Data$OPV, Data$PB, method = "spearman")
#Warning: Ties! Also wieder den Kendalls Tau Test
correlation_kendall <- cor.test(Data$OPV, Data$PB, method = "kendall")
print(correlation_kendall)
#p=0,05898 >0,05 but not much! 
#So we cant say that there is a significant correlation
#but we also cant say, that there is no correlation... 

ggplot(Data, aes(x = PB, y = OPV)) +
  geom_point() +
  labs(x = "PB (µm)", y = bquote("OPV ("~µm^3~")"), title = "Scatterplot OPV/PB") +
  geom_smooth(method = lm, se = TRUE) 

summary(lm_model)$r.squared
#R=0,04479895 also weit von eins weg, also keine gute lineare Abh.



########################################################################
##############       3) Untersuchung PB        #########################
########################################################################


hist(Data$PB)
shapiro.test(Data$PB)
#p=0,8079 > 0,05 -> Normalverteilt -> ANOVA ist i.O.
hist(Data$OPV)
shapiro.test(Data$OPV)
#=0,008112 < 0,05 -> nicht Normalverteilt -> ANOVA NICHT i.O.

# Erstellen des PB Punktdiagramms mit ggplot2
ggplot(Data, aes(x = Nummer, y = PB)) +
  geom_point() +
  labs(x = "Nummer", y = "PB (µm)", title = "Punktdiagramm der PB") +
  geom_smooth() +         # Trendlinie ist nich möglich, da Nummer caracter ist. Trendlinien gehen nur wenn beide variablen numeric sind
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust = 1)) #hier drehe ich die achsenbeschriftung 


### Boxplott von PB/Treatment machen
PBbp <- ggplot(Data, aes(y = PB, x = Treatment)) + 
  geom_boxplot() +
  labs(y = bquote("Prosomabreite (µm)"), title = "Boxplot PB")

print(PBbp)

###### Test auf Normalverteilung PB

### FW$OPV
shapiro_pbFW <- shapiro.test(subset_FW$PB)
# Ausgabe des Testergebnisses
print(shapiro_pbFW)
#p-value = 0.01361 <0,05 -> nicht normalverteilt

### FWp$OPV
shapiro_pbFWp <- shapiro.test(subset_FWp$PB)
# Ausgabe des Testergebnisses
print(shapiro_pbFWp)
#p-value = 0.3673 >0,05 -> normalverteilt

### FWpp$OPV
shapiro_pbFWpp <- shapiro.test(subset_FWpp$PB)
# Ausgabe des Testergebnisses
print(shapiro_pbFWpp)
#p-value = 0.4656 > 0,05 ->  normalverteilt

### Normalverteilung insgesamt:
shapiro_PB <- shapiro.test(Data$PB)
print(shapiro_OPV)
#p-value = 0.8079 > 0,05 normalverteilt.

### TEST auf Signifikante Unterschiede
anova_result <- aov(PB ~ Treatment, data = Data)
summary(anova_result)

#p=0,151 > 0,05   -> KEINE Signifikanz
#basierend auf diesem ANOVA-Test können wir nicht sagen, dass es einen signifikanten Unterschied zwischen den drei Treatments gibt.
#Es gibt keine ausreichenden Beweise dafür, dass sich die Mittelwerte der PB zwischen den Treatments unterscheiden.

########### PB/Mothersize ########

ggplot(Data, aes(x = Mother, y = PB)) +
  geom_point() +
  labs(x = "Mothersize (µm)", y = "BP (µm)", title = "Punktdiagramm PB/Mothersize") +
  geom_smooth(method = lm, se = TRUE) 

summary.lm(lm_model)





###########################################################################
######################### Origin  #########################################
###########################################################################


### Boxplott von OPV/Origin machen
ggplot(Data, aes(y = OPV, x = Origin)) + 
  geom_boxplot() +
  labs(y = bquote("Opisthosoma Volumen ("~µm^3~")"), title = "Boxplot OPV/Origin")

### Boxplott von FW: OPV/Origin machen
ggplot(subset_FW, aes(y = OPV, x = Origin)) + 
  geom_boxplot() +
  labs(y = bquote("Opisthosoma Volumen ("~µm^3~")"), title = "FW: Boxplot OPV/Origin")

### Boxplott von FW+: OPV/Origin machen
ggplot(subset_FWp, aes(y = OPV, x = Origin)) + 
  geom_boxplot() +
  labs(y = bquote("Opisthosoma Volumen ("~µm^3~")"), title = "FW+: Boxplot OPV/Origin")

### Boxplott von FW++: OPV/Origin machen
ggplot(subset_FWpp, aes(y = OPV, x = Origin)) + 
  geom_boxplot() +
  labs(y = bquote("Opisthosoma Volumen ("~µm^3~")"), title = "FW++: Boxplot OVP/Origin")

kruskal.test(OPV ~ Origin, data = Data)
summary
#p=0,1226 > 0,05
#Fundorte haben keinen signifikanten Einfluss auf die OPV basierend auf diesem ANOVA-Test.

##################### Boxplot PB gegen Origin. ###################################################################

### Boxplott von PB/Origin machen
ggplot(Data, aes(y = PB, x = Origin)) + 
  geom_boxplot() +
  labs(y = "PB (µm)", title = "Boxplot PB/Origin")

### Boxplott von FW: PB/Origin machen
ggplot(subset_FW, aes(y = PB, x = Origin)) + 
  geom_boxplot() +
  labs(y = "PB (µm)", title = "FW: Boxplot PB/Origin")

### Boxplott von FW+: PB/Origin machen
ggplot(subset_FWp, aes(y = PB, x = Origin)) + 
  geom_boxplot() +
  labs(y = "PB (µm)", title = "FW+: Boxplot PB/Origin")

### Boxplott von FW++: PB/Origin machen
ggplot(subset_FW, aes(y = PB, x = Origin)) + 
  geom_boxplot() +
  labs(y = "PB (µm)", title = "FW++: Boxplot PB/Origin")

anova_result <- aov(PB ~ Origin, data = Data)
summary(anova_result)
#p=0,419 > 0,05 
#Fundorte haben keinen signifikanten Einfluss auf die Prosomagröße basierend auf diesem ANOVA-Test.

###########################################################################
######################### ###  #########################################
##########################################################################






##########################################################
##############  Untersuchung Weight #########################
##########################################################

### Boxplott von Weight/Treatment machen
ggplot(Data, aes(y = Weight, x = Treatment)) + 
  geom_boxplot() +
  labs(y = "Weight (g)", title = "Boxplot Weight")


##########################################################
##############  Untersuchung Mothersize#########################
##########################################################

### Boxplott von Mothersize/Treatment machen
ggplot(Data, aes(y = Mother, x = Treatment)) + 
  geom_boxplot() +
  labs(y = "Muttergröße (µm)", title = "Boxplot Muttergröße")








########################################################################
#               OPV/PB Abhängigkeit von Fundort.                      #
########################################################################

